/*NumPlug WindowBlinds UIS plugin
 *Copyright (C) 2000 Laurence Parry (TheGreenReaper)
 *Version 0.50 (beta)
 *
 *This library is free software; you can redistribute it and/or
 *modify it under the terms of the GNU Lesser General Public
 *License as published by the Free Software Foundation; either
 *version 2.1 of the License, or (at your option) any later version.
 *
 *This library is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *Lesser General Public License for more details.
 *
 *You should have received a copy of the GNU Lesser General Public
 *License along with this library; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *Comments and questions to greenreaper@hotmail.com, www.redrival.com/exile/
 */

/*	Version history:
 *	
 *	0.01 - Initial alpha release (15/08/2000)
 *	0.02 - Second alpha release (17/08/2000)
 *				 Change to use of WBQuery (not timers), a few active/inactive fixes
 *				 System changed to use charmap - much more flexible (letters etc.)
 *	0.03 - More timer changes - alpha fade modes added
 *	0.50 - General beta release.
 */

// NB - this project has STRICT defined. I like strict :-)
#define STRICT
#include <windows.h>
#include <wingdi.h>

typedef LPSTR (CALLBACK* GETUISNAME) (void);
typedef void (CALLBACK* SETALPHA) (int, int);
GETUISNAME GetUIS;
GETUISNAME GetWBDIR;
SETALPHA SetButtonAlpha;
HWND last;
int timer = NULL;
// all UINT's and ULONG's in case people try putting -ve numbers in . . .
char * tmps = (char *)malloc(256 * sizeof(char));
ULONG repainttimer;
UINT tmp = 0;
UINT digits = 0;
char * digitsimage = (char *)malloc(256 * sizeof(char));
UINT digitswidth = 10;
UINT digitsheight = 15;
UINT updateinterval;
UINT nonfocusupdate;
ULONG startingnumber;
ULONG currentnumber;
ULONG maxnumber;
ULONG increasepercycle;
UINT cyclepos = 0;
UINT cyclelength;
char * pcyclenumber = NULL;
ULONG randmax;
ULONG randmin;
enum {COUNT_CYCLE, COUNT_INCREASE, COUNT_RANDOM};
UINT countermode;
enum {TRANS_REPLACE, TRANS_TOPSLIDE, TRANS_BOTTOMSLIDE};
UINT transitiontype;
enum {LEAD_ZERO, LEAD_BLANK, LEAD_SEPARATOR};
UINT leadingmode;
HBITMAP hDigitsBM = NULL;
HBITMAP hMemBM = NULL;
HDC hDigitsDC = NULL;
HDC hMemDC = NULL;
ULONG debugtimer = 0;
UINT lastinactive = FALSE;
char * pcharmap;
UINT charmaplen;
UINT alphalevel = 0;
UINT alphamode= 0;
UINT alphamax = 255;
UINT alphamin = 0;
UINT alphasteps = 16;
UINT alphadir = 1;
UINT hasdrawntimerup = 1;

VOID CALLBACK TimerProc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	// *This* is CNN^H^H^H . . . our timer proc
	if ((hasdrawntimerup == 0) || ((alphamode != 1) && (nonfocusupdate == 0) && (lastinactive != FALSE)) || ((alphamode == 1) && (lastinactive != FALSE) && (alphalevel == alphamin))) {
		return;
	}
	switch (countermode) {
		case COUNT_INCREASE:
			currentnumber = currentnumber + increasepercycle;
			if (currentnumber > maxnumber) {
				currentnumber = startingnumber;
			}
			break;

		case COUNT_RANDOM:
			do {
				currentnumber = ((rand() * rand() * rand()) % (randmax - randmin)); //random enough? ;-)
				//we don't want negatives - could be eliminated at rands but here more efficient (1 < 3)?
			} while (currentnumber < 0);
			currentnumber += randmin;
			break;

		case COUNT_CYCLE:
			cyclepos++;
			if (cyclepos == cyclelength) {
				cyclepos = 0;
			}
	}
	//Debug timing:
	//tmp = GetTickCount();
	//currentnumber = tmp - debugtimer;
	//debugtimer = tmp;
	
	// Force WB to redraw the window
	hasdrawntimerup = 0;
	SendMessage(last, WM_NULL, 600, 321);
}

BOOL APIENTRY DllMain(PVOID hModule, ULONG ulReason, PCONTEXT pctx)
{
	HINSTANCE hDLL;
	// it is assumed that WBLIND.DLL has already been loaded into the
	// process address space (if WB is running, it will be). This means
	// you cannot debug this application without WB running.
	// Just so you don't try :-)
	if (ulReason == DLL_PROCESS_ATTACH) {	
		hDLL = GetModuleHandle("WBLIND.DLL");
		if (hDLL == NULL) { // we can't proceed
			exit(-1);
		}
		GetUIS = (GETUISNAME)GetProcAddress(hDLL, "GetUIS");
		GetWBDIR = (GETUISNAME)GetProcAddress(hDLL, "GetWBDIR");
		SetButtonAlpha = (SETALPHA)GetProcAddress(hDLL, "SetButtonAlpha");
		if (GetUIS != NULL)
		{
			strcpy(tmps, GetUIS());
		}
		//General init
		digits = GetPrivateProfileInt("NumPlug", "Digits", 0, tmps);
		countermode = GetPrivateProfileInt("NumPlug", "CounterMode", 0, tmps);
		transitiontype = GetPrivateProfileInt("NumPlug", "TransitionType", 0, tmps);
		leadingmode = GetPrivateProfileInt("NumPlug", "LeadingMode", 0, tmps);
		updateinterval = GetPrivateProfileInt("NumPlug", "UpdateInterval", 300, tmps);
		nonfocusupdate = GetPrivateProfileInt("NumPlug", "NonFocusUpdate", 0, tmps);
		alphamode = GetPrivateProfileInt("NumPlug", "AlphaMode", 0, tmps);
		if (alphamode != 0) { // put here to decrease the number of reads
			if (alphamode > 2) { // sanity check 1
				alphamode = 2;
			}
			alphalevel = GetPrivateProfileInt("NumPlug", "AlphaLevel", 254, tmps);
			alphamin = GetPrivateProfileInt("NumPlug", "AlphaMin", 0, tmps);
			if (alphamin > 254) { // sanity check 2
				alphamin = 254; // yes, I know this *should* be 255,
			}
			alphamax = GetPrivateProfileInt("NumPlug", "AlphaMax", 254, tmps);
			if (alphamax > 254) { // sanity check 3
				alphamax = 254; // but it doesn't work, and 254 does . . . *sigh*
			}
			alphasteps = GetPrivateProfileInt("NumPlug", "AlphaSteps", 16, tmps);
			alphadir = GetPrivateProfileInt("NumPlug", "AlphaDir", 1, tmps);
			if (alphadir > 1) { // sanity check 4
				alphadir = 1;
			}
		}
		char * startnumstr = (char *)malloc(256 * sizeof(char));
		GetPrivateProfileString("NumPlug", "StartingNumber", "0", startnumstr, 256, tmps);
		startingnumber = atol((const char *)startnumstr);
		// piggybacks charmap on startnumstr . . .
		GetPrivateProfileString("NumPlug", "CharMap", "0123456789._", startnumstr, 256, tmps);
		tmp = lstrlen(startnumstr);
		if (tmp == 0) { // someone forgot charmap . . . or actually released a skin with 0.01
			pcharmap = "0123456789._"; // either way they're mad . . . but that's OK - <mad g>
		}
		else {
			pcharmap = (char *)malloc((tmp + 1) * sizeof(char));
			lstrcpyn(pcharmap, startnumstr, tmp + 1);
		}
		charmaplen = lstrlen(pcharmap);
		free(startnumstr);
		srand((unsigned)GetTickCount()); // randomise
		switch (countermode) { //try and reduce number of lookups
			case COUNT_INCREASE:
				{
				increasepercycle = GetPrivateProfileInt("NumPlug","IncreasePerCycle", 1, tmps);
				char * maxnumstr = (char *)malloc(256 * sizeof(char));
				GetPrivateProfileString("NumPlug","MaxNumber", "0", maxnumstr, 256, tmps);
				maxnumber = atol((const char *)maxnumstr);
				free(maxnumstr);
				break;
				}

			case COUNT_RANDOM:
				randmax = GetPrivateProfileInt("NumPlug","RandMax", 1, tmps);	
				randmin = GetPrivateProfileInt("NumPlug","RandMin", 0, tmps);	
				break;
		
			case COUNT_CYCLE:
				cyclelength = GetPrivateProfileInt("NumPlug","CycleLength", 0, tmps);
				// this gets messy . . .
				char * cyclename = (char *)malloc(20 * sizeof(char));
				char * cyclenamenum = (char *)malloc(10 * sizeof(char));
				/* - this is the old code
				char * cyclenumstr = (char *)malloc(256 * sizeof(char));
				pcyclenumber = (long *)malloc(cyclelength * sizeof(long));
				for (int i = 0;i < cyclelength;i++) {
					*cyclename = (char)0x0;
					strcpy(cyclename, "CycleNum");
					itoa(i, cyclenamenum, 10);
					strcat(cyclename, (const char *)cyclenamenum);
					GetPrivateProfileString("NumPlug", cyclename, "0", cyclenumstr, 256, tmps);
					*(pcyclenumber + i) = atol(cyclenumstr);
				}
				*/
				// now uses char * for putting '.' or in, etc - allocate max possible + uses wsprintf not strcat/cpy
				pcyclenumber = (char *)malloc(cyclelength * sizeof(char) * (digits + 1));
				for (UINT i = 0;i < cyclelength;i++) {
					itoa(i, cyclenamenum, 10);
					wsprintf(cyclename, "CycleNum%s", cyclenamenum);
					GetPrivateProfileString("NumPlug", cyclename, "0", (char *)(pcyclenumber + i * (digits + 1)), (digits + 1), tmps);
				}
				free(cyclename);
				free(cyclenamenum);
				//free(cyclenumstr);
		}
		GetPrivateProfileString("NumPlug","DigitsImage", "digits.bmp", digitsimage, 256, tmps);
		wsprintf(tmps, "%s\\%s", GetWBDIR(), digitsimage);
		// LR_LOADFROMFILE unsupported under NT (according to MSDN 1997)? Apparently not . . . maybe in 3.5
		hDigitsBM = (HBITMAP)LoadImage(NULL, tmps, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
		currentnumber = startingnumber;
		//repainttimer = GetTickCount();
		timer = SetTimer(NULL, NULL, updateinterval, (TIMERPROC)TimerProc);
	}
	if (ulReason == DLL_PROCESS_DETACH) {
		if (timer != NULL) {
			KillTimer(NULL, timer); // no HWND since a global timer
			timer = NULL;
		}
		if (hDigitsDC != NULL) { // just in case . . .
			DeleteDC(hDigitsDC);
			hDigitsDC = NULL;
		}
		if (hDigitsBM != NULL) {
			DeleteObject(hDigitsBM);
			hDigitsBM = NULL;
		}
	}
	return TRUE;
}

BOOL WBDrawMulti (HWND hWnd, HDC hDC, RECT* pRect, int state, BOOL active, int button)
{
	/*
		hWnd = Handle to window
		hDC = Handle to Device Context
		pRect = Dimensions of item
		state = > 0 then its pressed, else not pressed
		active = This is TRUE when the window is active and FALSE when inactive	
	*/
	//Debug timing
	//countermode = COUNT_INCREASE; // has to != COUNT_CYCLE
	//tmp = GetTickCount();
	//currentnumber = tmp - debugtimer;
	//debugtimer = tmp;
	int width = pRect->right - pRect->left;
	int height = pRect->bottom - pRect->top;
	//if (hDigitsDC == NULL) {
	//hMemBM = CreateCompatibleBitmap(hDC, width, height);
	hDigitsDC = CreateCompatibleDC(hDC);
	//hMemDC = CreateCompatibleDC(hDC);
	DeleteObject(SelectObject(hDigitsDC, hDigitsBM));
	//DeleteObject(SelectObject(hMemDC, hMemBM));
	//}
	//OK, this is the fun bit . . .
	//Lots of pointers for the speed (I hope :-) rather than using strcat etc.
	//of course, the main thing is the blitting . . . possibly buffer it,
	//and then not write to the buffer if it's the same char? But would have to blit
	//the buffer as well as single characters - there's no flicker atm so no.
	char * outstr;
	char * digitpos;
	if (countermode != COUNT_CYCLE) {
		ltoa(currentnumber, tmps, 10);
		tmp = lstrlen(tmps);
		if (tmp > digits) { // *sigh* - someone (me? you?) put too many digits in :-(
			tmp = digits;			// 'handle' it by ignoring the last ones - <g>
		}
		// this might slow it down . . . maybe . . . probably not much though
		outstr = (char *)malloc((digits + 1) * sizeof(char));
		// insert padding
		char * outpos = outstr;
		*outstr = (char)0x0;
		char * digitpos = tmps;
		for (int i = digits - tmp;i > 0;i--) {
			switch (leadingmode) {
				case LEAD_ZERO:
					*outpos = '0';
					break;
				
				case LEAD_BLANK:
					*outpos = '_'; // '_' not ' ' for cycle use
					break;
	
				case LEAD_SEPARATOR:
					*outpos = '.';
					break;
			}
			outpos++;
		}
		//copy the real digits
		for (int j = tmp;j > 0;j--) {
			*outpos = *digitpos;
			digitpos++;
			outpos++;
		}
		*outpos = 0x0; //terminate with an null for good luck
	}
	else {
		outstr = (pcyclenumber + (cyclepos * (digits + 1)));
	}
	// calculate y-position of digit bitmaps to copy
	// also used in timerproc for checking if the timer update should be aborted
	if (active) {
		if (alphamode == 1) {
			alphadir = 1;
		}
		lastinactive = FALSE; // == 0
	}
	else {
		if (alphamode == 1) {
			alphadir = 0;
		}
		lastinactive = digitsheight; // == TRUE
	}
	// now decide if this is an alpha update, and if so update
	if (hasdrawntimerup == 1) {
		if (alphamode != 0) {
			if (alphadir == 1) {	
				if ((alphalevel + alphasteps) > alphamax) {
					alphalevel = alphamax;
					if (alphamode == 2) {
						alphadir = 0;
					}
				}
				else {
					alphalevel = alphalevel + alphasteps;
				}
			}
			else {
				int negtest = alphalevel - alphasteps;
				if (negtest < (int)alphamin) {
					alphalevel = alphamin;
					if (alphamode == 2) {
						alphadir = 1;
					}
				}
				else {
					alphalevel = alphalevel - alphasteps;
				}
			}
			SetButtonAlpha(button, alphalevel);
		}
	}
	//if ((timer == NULL) && ((active != FALSE) || (nonfocusupdate != 0))) {
	//	timer = SetTimer(hWnd, 1, updateinterval, (TIMERPROC)TimerProc);
	//}
	//clear first just in case the skin author got the width/digits wrong, then
	//output the string by going through outstr and blitting a digit at a time
	
	//on second thought don't clear because could lower performance . . .
	//you can count how many digits to include, right? (I hope . . . ;-)
	//BitBlt(hDC, 0, 0, width, height, hDigitsDC, 0, 0, BLACKNESS);
	/* - OLD 0.01 CODE
	*(tmps + sizeof(char)) = 0x0;
	for (int k = lstrlen(outstr);k > 0;k--) {
		switch (*digitpos) {
			case '_':
				BitBlt(hDC, (digits - k) * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, 11 * digitswidth, lastinactive, SRCCOPY);
				break;

			case '.':
				BitBlt(hDC, (digits - k) * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, 10 * digitswidth, lastinactive, SRCCOPY);
				break;

			default:
				*tmps = *digitpos;
				tmp = atoi((const char *)tmps);
				BitBlt(hDC, (digits - k) * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, tmp * digitswidth, lastinactive, SRCCOPY);
				break;
		}
		digitpos++;
	}
	*/
	// NEW 0.02 flexible alphanumeric code
	
	UINT progress;
	char * charmappos;
	digitpos = outstr;
	for (UINT k = 0;k < digits;k++) {
		charmappos = pcharmap;
		progress = 0;
		while (((char)*charmappos != (char)*digitpos) && (progress <= charmaplen)) {
			charmappos++;
			progress++;
		}
		if (progress <= charmaplen) {
			if (alphamode == 1) { // then always draw active
				BitBlt(hDC, k * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, progress * digitswidth, 0, SRCCOPY);
			}
			else {
				BitBlt(hDC, k * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, progress * digitswidth, lastinactive, SRCCOPY);
			}
		}
		else { // Someone forgot to put in enough characters . . .
			BitBlt(hDC, k * digitswidth, 0, digitswidth, digitsheight, hDigitsDC, 0, 0, BLACKNESS);
		}
		digitpos++;
	}
	last = hWnd;
	// reinstated
	DeleteDC(hDigitsDC);
	//DeleteDC(hMemDC);
	//DeleteObject(hMemBM);
	if (countermode != COUNT_CYCLE) { // if not then don't as we didn't allocate it here
		free(outstr);	// was allocated at startup and must remain - *FOREVER*
	}
	hasdrawntimerup = 1;
	return TRUE;
}
// Have a lot of fun . . .